/*
 * MonitorState.java
 *
 * 
 */
 package DisCSP.DistributedCSP;

import java.net.*;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


 class MonitorState
{
	private boolean consistent = false;
	private InetAddress address;
	private int port;

 	/** Costruttore di MonitorState
     * 
     * @param addr l'IP del Monitor
     * @param p la porta del Monitor
     * 
     */	
	
	public MonitorState(String addr,int p)
	{
		try
		{	
			address=InetAddress.getByName(addr);
		}
		catch(UnknownHostException he)
		{
			
		}
		port=p;
	}
	
	/**Permette di verificare se  stata raggiunta la consistenza
     * 
     * @return true se  stata raggiunta la consistenza, false altrimenti
     * 
     */		
	public boolean consistent()
	{
		return consistent;
	}
	
	/** Permette di specificare se  stata raggiunta la consistenza
     * 
     * @param c true se  stata raggiunta la consistenza, false altrimenti
     * 
     */		
	public void setConsistent(boolean c)
	{
		consistent=c;
	}

	
	/** Restituisce l'indirizzo IP del monitor come stringa
     * 
     * @return una stringa rappresentante l'indirizzo IP del monitor
     * 
     */		
	
	public String address()
	{
		return address.getHostAddress();
	}
	
	/** Restituisce la porta del monitor
     * 
     * @return l'intero corrispondente alla porta del monitor
     * 
     */		
	
	public int port()
	{
		return port;
	}	
	
}
